package com.ejie.ab04b.exception;

import com.ejie.ab04b.util.Utilities;

/**
 * Excepcion que indica un error en la ejecucion de una invocacion a un servicio
 * web
 * 
 * @author Aitor_Roncero
 * 
 */
public class AB04BException extends Exception {

	private static final long serialVersionUID = -13430036L;

	// target de la excepcion
	private final Throwable target;
	// Trazas o valores extra a indicar relacionados con la excepcion
	private final String contenido;

	/**
	 *  paramThrowable
	 * 	 * 	 *            Throwable
	 *  message
	 * 	 * 	 *            String.
	 * 	 *
	 *  paramThrowable the param throwable
	 *  message the message
	 *
	 * @param paramThrowable the param throwable
	 * @param message the message
	 */
	public AB04BException(Throwable paramThrowable, String message) {
		super(message, paramThrowable);
		this.target = paramThrowable;
		this.contenido = message + "\n" + Utilities.getInstance().getStackTrace(paramThrowable);
	}

	/**
	 *  paramThrowable
	 * 	 * 	 *            Throwable.
	 * 	 *
	 *  paramThrowable the param throwable
	 *
	 * @param paramThrowable the param throwable
	 */
	public AB04BException(Throwable paramThrowable) {
		super(paramThrowable);
		this.target = paramThrowable;
		this.contenido = null;
	}

	/**
	 *  message
	 * 	 * 	 *            AB04BException.
	 * 	 *
	 *  message the message
	 *
	 * @param message the message
	 */
	public AB04BException(String message) {
		super(message);
		this.target = null;
		this.contenido = null;
	}

	/**
	 *  Throwable.
	 * 	 *
	 *  the target
	 *
	 * @return the target
	 */
	public Throwable getTarget() {
		return this.target;
	}

	/**
	 *  String.
	 * 	 *
	 *  the contenido
	 *
	 * @return the contenido
	 */
	public String getContenido() {
		return this.contenido;
	}

}
